### 1. CPU Resource Sharing and Risks

- The CPU in network devices handles three main functions:
    - Control plane
    - Management plane
    - Slow data path
- Excessive traffic to any function can overwhelm the CPU, impacting all three functions.
- Flooding attacks can target the CPU with high packet rates, potentially disabling critical functions.

---

### 2. Countermeasures Against CPU Overload

#### a. Device-Centric Data Plane ACLs

- Typically implemented as interface ACLs on routers, switches, and firewalls.
- Purpose:
    - Deny unwanted traffic before it reaches the CPU (slow path).
- Efficiency:
    - Often hardware-implemented (especially in OSI Layer 3 switches and high-end routers).
    - Can drop most malicious traffic without CPU impact.
- Deployment:
    - Can be placed at the network edge as infrastructure ACLs.
    - Reduces the need for ACLs on every device.
- Configuration Challenges:
    - Must specify destination addresses of infrastructure devices.
    - Scalability issues if devices have many or non-contiguous IP addresses.

#### b. Infrastructure ACLs vs. Device-Centric Methods

- **Infrastructure ACLs:**
    - Applied at the network edge (input direction on access Layer 3 devices).
    - Filter traffic before it can reach device CPUs.
- **Device-Centric Methods:**
    - Personal firewalls on each device.
    - Control plane rate limiters (e.g., CoPP, CPPr).

---

### 3. Infrastructure ACL Policies

- **Default Policies:**
    - Drop and log all traffic to network infrastructure device IP addresses.
        - Prevents users from sending routing or management traffic to devices.
        - Requires including all device IPs in ACLs.
        - Does not block malicious transit traffic requiring CPU-intensive processing.
    - Permit all other transit traffic.
- **Exceptions:**
    - Some signaling, such as BGP sessions from external networks, may require rule exceptions.

---

### 4. Implementation Guidelines

- Use traditional Cisco IOS XE ACLs or Cisco Secure Firewall access policies.
- Rate-limiting (e.g., class-based policing) can be used for exceptions.
- A structured addressing plan helps minimize ACL size.
    - Without this, consider only on-device countermeasures.
- **Cisco Secure Firewall Threat Defense:**
    - Prefilter policies can filter infrastructure-destined traffic.
    - Criteria: IP addresses, VLAN tag, port, and protocol.
    - Improves performance by preventing unnecessary evaluations.

---

**Key Points to Remember:**

- Infrastructure ACLs protect device CPUs from unwanted traffic.
- Proper design and placement of ACLs are essential for effective protection and manageability.
- Exceptions and structured addressing are crucial for scalability and flexibility.